<?php
session_start();

class Security {
    
    public static function sanitizeInput($input) {
        if (is_array($input)) {
            return array_map([self::class, 'sanitizeInput'], $input);
        }
        return htmlspecialchars(strip_tags(trim($input)), ENT_QUOTES, 'UTF-8');
    }
    
    public static function validatePhone($phone) {
        return preg_match('/^01[3-9]\d{8}$/', $phone);
    }
    
    public static function validatePassword($password) {
        return strlen($password) >= 6;
    }
    
    public static function generateCSRFToken() {
        if (empty($_SESSION['csrf_token'])) {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        }
        return $_SESSION['csrf_token'];
    }
    
    public static function verifyCSRFToken($token) {
        return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
    }
    
    public static function checkBruteForce($ip, $action) {
        $key = "attempts_{$action}_{$ip}";
        $attempts = $_SESSION[$key] ?? 0;
        
        if ($attempts >= MAX_LOGIN_ATTEMPTS) {
            $_SESSION[$key . '_lockout'] = time();
            return false;
        }
        
        if (isset($_SESSION[$key . '_lockout'])) {
            if (time() - $_SESSION[$key . '_lockout'] < LOGIN_LOCKOUT_TIME) {
                return false;
            }
            unset($_SESSION[$key . '_lockout']);
            $_SESSION[$key] = 0;
        }
        
        return true;
    }
    
    public static function recordAttempt($ip, $action) {
        $key = "attempts_{$action}_{$ip}";
        $_SESSION[$key] = ($_SESSION[$key] ?? 0) + 1;
    }
}
?>